//*****************************************************************************************************************************************************
//
//  Sample Program for LCD Image
//
//  Target Machine : CPT-711
//
//  Function:
//  void get_image(int left, int top, int width, int height, unsigned char *pag) : Read the bitmap pattern of a rectangular arrea on the LCD display.
//                 int left           : x coordinate of the upper left comer of the rectangle.
//                 int top            : y coordinate of the upper left comer of the rectangle.
//                 int width          : the width in dots of the rectangle.
//                 int height         : the height in dots of the rectangle.
//                 unsigned char *pat : the buffer where bitmap data will be copied to.
//
//  void show_image(int left,int top, int width, int height, unsigned char *pag) : Put a rectangular bitmap to the LCD display.
//                 int left           : x coordinate of the upper left comer of the rectangle.
//                 int top            : y coordinate of the upper left comer of the rectangle.
//                 int width          : the width in dots of the rectangle.
//                 int height         : the height in dots of the rectangle.
//                 unsigned char *pat : the buffer that hold the bitmap to be display.
//
//  SYNTECH INFORMATION CO., LTD.
//
//*****************************************************************************************************************************************************

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "..\lib\711lib.h"

void main (void)
    {
    unsigned char  cshow[8][8] =
         { { 0x00, 0x06, 0x06, 0x06, 0x06, 0x7e, 0x7e, 0x00 },
           { 0x00, 0x3e, 0x46, 0x06, 0x06, 0x46, 0x3e, 0x00 },
           { 0x00, 0x3e, 0x46, 0x46, 0x46, 0x46, 0x3e, 0x00 },
           { 0x00, 0x7e, 0x18, 0x18, 0x18, 0x18, 0x7e, 0x00 },
           { 0x00, 0x66, 0x66, 0x5a, 0x42, 0x42, 0x42, 0x00 },
           { 0x00, 0x18, 0x2c, 0x66, 0x66, 0x7e, 0x66, 0x00 },
           { 0x00, 0x3e, 0x06, 0x06, 0x76, 0x66, 0x7e, 0x00 },
           { 0x00, 0x7e, 0x06, 0x06, 0x7e, 0x06, 0x7e, 0x00 } };

    clr_scr ();

    show_image ( 8, 16, 8, 8, cshow[0]);  // L
    show_image (16, 16, 8, 8, cshow[1]);  // C
    show_image (24, 16, 8, 8, cshow[2]);  // D

    show_image (40, 16, 8, 8, cshow[3]);  // I
    show_image (48, 16, 8, 8, cshow[4]);  // M
    show_image (56, 16, 8, 8, cshow[5]);  // A
    show_image (64, 16, 8, 8, cshow[6]);  // G
    show_image (72, 16, 8, 8, cshow[7]);  // E

    while (getchar() != KEY_ESC);
    }
//-------------------------------------------------------------------------//
